/* =========================================================
   SuperCRM - BLOQUEO QUIRÚRGICO "RECUPERAR ACCESO"
   Archivo: content/index.js
   Ubicación: PEGAR ANTES de la línea 1 (antes de __vitePreload)

   Importante:
   - Bloquea SOLO el click del botón/link cuyo texto exacto sea:
     "Recuperar acceso" o "Recuperar acesso"
   - NO bloquea Login
========================================================= */
(() => {
  const normalize = (s) => (s || "").replace(/\s+/g, " ").trim().toLowerCase();

  const isRecoverText = (txt) => {
    const t = normalize(txt);
    return t === "recuperar acceso" || t === "recuperar acesso";
  };

  const getOwnText = (el) => {
    try { return el?.innerText || el?.textContent || ""; } catch { return ""; }
  };

  const findClickable = (target) => {
    if (!target || target.nodeType !== 1) return null;
    return target.closest('button, a, [role="button"], input[type="button"], input[type="submit"]');
  };

  document.addEventListener(
    "click",
    (e) => {
      const clickable = findClickable(e.target);
      if (!clickable) return;

      const txt = getOwnText(clickable);
      if (isRecoverText(txt)) {
        e.preventDefault();
        e.stopPropagation();
        if (typeof e.stopImmediatePropagation === "function") e.stopImmediatePropagation();
        console.warn("[SuperCRM] Bloqueado: Recuperar acceso");
      }
    },
    true
  );
})();

function __vitePreload(baseModule, deps, importerUrl) {
    let promise = Promise.resolve();
    if (deps && deps.length > 0) {
        document.getElementsByTagName("link");
        const cspNonceMeta = document.querySelector("meta[property=csp-nonce]");
        const cspNonce = (cspNonceMeta == null ? void 0 : cspNonceMeta.nonce) || (cspNonceMeta == null ? void 0 : cspNonceMeta.getAttribute("nonce"));
        promise = Promise.allSettled(deps.map((dep) => {
            dep = assetsURL(dep);
            if (dep in seen)
                return;
            seen[dep] = true;
            const isCss = dep.endsWith(".css");
            const cssSelector = isCss ? '[rel="stylesheet"]' : "";
            if (document.querySelector(`link[href="${dep}"]${cssSelector}`)) {
                return;
            }
            const link = document.createElement("link");
            link.rel = isCss ? "stylesheet" : scriptRel;
            if (!isCss) {
                link.as = "script";
            }
            link.crossOrigin = "";
            link.href = dep;
            if (cspNonce) {
                link.setAttribute("nonce", cspNonce);
            }
            document.head.appendChild(link);
            if (isCss) {
                return new Promise((res, rej) => {
                    link.addEventListener("load", res);
                    link.addEventListener("error", () => rej(new Error(`Unable to preload CSS for ${dep}`)));
                });
            }
        }));
    }
    function handlePreloadError(err) {
        const e = new Event("vite:preloadError", {
            cancelable: true
        });
        e.payload = err;
        window.dispatchEvent(e);
        if (!e.defaultPrevented) {
            throw err;
        }
    }
    return promise.then((res) => {
        for (const item of res || []) {
            if (item.status !== "rejected")
                continue;
            handlePreloadError(item.reason);
        }
        return baseModule().catch(handlePreloadError);
    });
}__vitePreload(()=> import(chrome.runtime.getURL("content/assets/js/v_7_4_3_6_3dde09db-99f5-4187-8a7e-903456f0360f21.js")),[]);__vitePreload(()=> import(chrome.runtime.getURL("content/assets/js/v_7_4_3_6_3dde09db-99f5-4187-8a7e-903456f0360f22.js")).then(r=>r.m),[]);
